############### ###############
## F_H2_meetings
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  plot1 <- ggplot(CBO_groups_final %>% drop_na(meetings_general),
                  aes(x = meetings_general)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Number of general membership meetings \n held by the CBO in 2020", 
      y = "Number of CBOs"
    ) +
    theme_minimal() +
    scale_y_continuous(limits = c(0,200)) + 
    theme(text = element_text(size=11, family="Times"))
  
  plot2 <- ggplot(CBO_groups_final %>% drop_na(meetings_executive),
                  aes(x = meetings_executive)) + 
    geom_histogram() + 
    labs(
      x = "Number of executive board meetings \n held by the CBO in 2020", 
    ) +
    theme_minimal() +
    scale_y_continuous(limits = c(0,200)) + 
    theme(text = element_text(size=11, family="Times"), 
          axis.title.y=element_blank())
  
  ggarrange(plot1, plot2, align = "hv") +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H2_", "meetings.png"), device = png,  dpi=200)
  


